# installer for davisconsoleapi

#import sys
#import weewx
import os.path
import configobj

import setup
import distutils

#from weecfg.extension import ExtensionInstaller

def loader():

    return DavisConsoleAPIInstaller()

class DavisConsoleAPIInstaller(setup.ExtensionInstaller):
    def __init__(self):
        super(DavisConsoleAPIInstaller, self).__init__(
            version='0.43',
            name='davisconsoleapi',
            description='Collect and display the station information from the Davis Weatherlink Console 6313 API.',
            author='Werner Krenn',
            author_email='',
            #data_services = 'user.davisconsolehealthapi.DavisConsoleHealthAPI',
            config = {
                'Station': {
                    'station_type': 'DavisConsoleAPI',
                    'station_type_new': 'DavisConsoleAPI',
                },
                'Engine': {
                    'Services': {
                        'data_services': ',',
                    }
                },
                'DataBindings': {
                    'wx_binding': {
                        'database': 'davisconsoleapi_sqlite',
                        'database_new': 'davisconsoleapi_sqlite',
                        'table_name': 'archive',
                        'manager': 'weewx.manager.DaySummaryManager',
                        'schema': 'schemas.wview_davisconsoleapi.schema',
                        'schema_new': 'schemas.wview_davisconsoleapi.schema',
                    }
                },
                'Databases': {
                    'davisconsoleapi_sqlite': {
                        'database_type': 'SQLite',
                        'database_name': 'davisconsole.sdb',}
                },
                'Accumulator': {
                    'consoleRadioVersionC': {
                        'accumulator': 'firstlast',
                        'extractor': 'last',},
                    'consoleSwVersionC': {
                        'accumulator': 'firstlast',
                        'extractor': 'last',},
                    'consoleOsVersionC': {
                        'accumulator': 'firstlast',
                        'extractor': 'last',}
                },
                'StdReport': {
                    'SeasonsReport': {
                        'enable': 'false',
                        'HTML_ROOT': '/var/www/html/weewx/Season',
                    },
                    'DavisConsole': {
                        'skin': 'console',
                        'lang': 'en',
                        'enable': 'true',
                        'HTML_ROOT': '/var/www/html/weewx',
                    },
                    'DavisConsoleHealth': {
                        'skin': 'healthc',
                        'lang': 'en',
                        'enable': 'true',
                        'HTML_ROOT': '/var/www/html/weewx/healthc',
                    },
                },
                'DavisConsoleAPI': {
                    'driver': 'user.davisconsoleapi',
                    'station_id': '?????',
                    'api_key': 'abcdefghijklmnopqrstuvwzyx123456',
                    'api_secret': '123456abcdefghijklmnopqrstuvwxyz',
                    'packet_log': '0',
                    'txid_iss': '1',
                    'txid_iss2': 'None',
                    'txid_leaf_soil': 'None',
                    'txid_leaf': 'None',
                    'txid_soil': 'None',
                    'txid_wind': 'None',
                    'txid_extra1': 'None',
                    'txid_extra2': 'None',
                    'txid_extra3': 'None',
                    'txid_extra4': 'None',
                    'txid_rain': 'None',
                    'airlink': '0',
                },
                'RadiationDays': {
                    'min_sunshine': '120',
                    'sunshine_coeff': '0.95',
                    'sunshine_min': '18',
                    'sunshine_loop': '1',
                    'rainDur_loop': '0',
                    'sunshine_log': '0',
                    'rainDur_log': '0',
                    'rain2': '1',
                    'sunshine2': '0',
                    'sunshine2_loop': '1',
                    'rainDur2_loop': '0',
                    'sunshine2_log': '0',
                    'rainDur2_log': '0',
                },
            },
            files=[
                ('bin/user', [
                    'bin/user/davisconsoleapi.py',
                    'bin/user/historygenerator3.py',
                    'bin/user/historygenerator42.py',
                    'bin/user/sunevents.py',
                    'bin/user/sunrainduration.py',
                ]),
                ('bin/schemas', [
                    'bin/schemas/wview_davisconsoleapi.py',
                ]),
                ('skins', [
                    'skins/console/index.html.tmpl',
                    'skins/console/celestial.html.tmpl',
                    'skins/console/statistics.html.tmpl',
                    'skins/console/tabular.html.tmpl',
                    'skins/console/rss.xml.tmpl',
                    'skins/console/telemetry.html.tmpl',
                    'skins/console/skin.conf',
                    'skins/console/about.inc',
                    'skins/console/analytics.inc',
                    'skins/console/celestial.inc',
                    'skins/console/current.inc',
                    'skins/console/hilo.inc',
                    'skins/console/identifier.inc',
                    'skins/console/map.inc',
                    'skins/console/radar.inc',
                    'skins/console/satellite.inc',
                    'skins/console/sensors.inc',
                    'skins/console/statistics.inc',
                    'skins/console/sunmoon.inc',
                    'skins/console/titlebar.inc',
                    'skins/console/console.css',
                    'skins/console/console.js',
                    'skins/console/favicon.ico',
                    'skins/console/healthc.inc',
                    'skins/console/lang/de.conf',
                    'skins/console/lang/en.conf',
                    'skins/console/NOAA/NOAA-%Y.txt.tmpl',
                    'skins/console/NOAA/NOAA-%Y-%m.txt.tmpl',
                    'skins/console/font/license.txt',
                    'skins/console/font/OFL.txt',
                    'skins/console/font/OpenSans.woff2',
                    'skins/console/font/OpenSans.woff',
                    'skins/console/font/OpenSans-Bold.ttf',
                    'skins/console/font/OpenSans-Regular.ttf',
                    'skins/console/font/Kanit-Bold.ttf',
                    'skins/console/font/Kanit-Regular.ttf',
                    'skins/healthc/index.html.tmpl',
                    'skins/healthc/skin.conf',
                    'skins/healthc/healthc.css',
                    'skins/healthc/healthc.js',
                    'skins/healthc/favicon.ico',
                    'skins/healthc/identifier.inc',
                    'skins/healthc/sensors.inc',
                    'skins/healthc/sensorsair.inc',
                    'skins/healthc/titlebar.inc',
                    'skins/healthc/about.inc',
                    'skins/healthc/lang/de.conf',
                    'skins/healthc/lang/en.conf',

                ]),
            ]
        )
